using System;

namespace OverridingInterfaces
{
	interface IStorable
	{
		void Read();
		void Write();
	}

	interface ITalk
	{
		void Talk();
		void Read();
	}

	// Nowa wersja klasy Document implementuje take interfejs ITalk
	public class Document : IStorable, ITalk
	{
		// Konstruktor obiektw klasy Document
		public Document(string s)
		{
			Console.WriteLine(
			   "Tworzenie dokumentu: {0}", s);
		}

		// Niejawna implementacja
		public virtual void Read()
		{
			Console.WriteLine(
			   "Metoda Read interfejsu IStorable w klasie Document");
		}

		public void Write()
		{
			Console.WriteLine(
			   "Metoda Write interfejsu IStorable w klasie Document");
		}

		// Jawna implementacja
		void ITalk.Read()
		{
			Console.WriteLine("Implementacja metody ITalk.Read");
		}

		public void Talk()
		{
			Console.WriteLine("Implementacja metody ITalk.Talk");
		}
	}

	class Tester
	{
		public void Run()
		{
			// Tworzenie obiektu klasy Document
			Document theDoc = new Document("Dokument testowy");
			IStorable isDoc = theDoc as IStorable;
			if (isDoc != null)
			{
				isDoc.Read();
			}

			// Rzutowanie na interfejs ITalk
			ITalk itDoc = theDoc as ITalk;
			if (itDoc != null)
			{
				itDoc.Read();
			}

			theDoc.Read();
			theDoc.Talk();
		}

		[STAThread]
		static void Main()
		{
			Tester t = new Tester();
			t.Run();
		}
	}
}
